#include "c16x12r_resources.h"
/**
 * @brief Memory buffers for 16x12 R Click.
 */
 
// MIKROE logo image, 12x16px, LSB little-endian format
const uint16_t c16x12r_img_mikroe[ ] = 
{
    0x0000, 0x318C, 0x318C, 0x318C, 0x318C, 0x318C, 0x318C, 0x318C, 0x399C, 0x1FF8, 0x0FF0, 0x0000
};
 
// MIKROE logo image inverted, 12x16px, LSB little-endian format
const uint16_t c16x12r_img_mikroe_inv[ ] = 
{
    0xFFFF, 0xCE73, 0xCE73, 0xCE73, 0xCE73, 0xCE73, 0xCE73, 0xCE73, 0xC663, 0xE007, 0xF00F, 0xFFFF
};

// Default font
const uint16_t c16x12r_font[ ][ 12 ] =
{
    { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char space
    { 0x0000, 0x0000, 0x0000, 0x0000, 0x03F4, 0x03F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char !
    { 0x0000, 0x0000, 0x0000, 0x0700, 0x0700, 0x0000, 0x0700, 0x0700, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char "
    { 0x0000, 0x0000, 0x0000, 0x0018, 0x00DE, 0x00F8, 0x03D8, 0x00DE, 0x00F8, 0x03D8, 0x00C0, 0x0000 }, // Code for char #
    { 0x0000, 0x0000, 0x0000, 0x00C8, 0x01E4, 0x013F, 0x07E4, 0x013C, 0x0098, 0x0000, 0x0000, 0x0000 }, // Code for char $
    { 0x01C0, 0x03E0, 0x0220, 0x03E0, 0x01CC, 0x0030, 0x00C0, 0x0338, 0x007C, 0x0044, 0x007C, 0x0038 }, // Code for char %
    { 0x0000, 0x0000, 0x01B8, 0x03FC, 0x0244, 0x03E4, 0x01B4, 0x0018, 0x006C, 0x0044, 0x0000, 0x0000 }, // Code for char &
    { 0x0000, 0x0000, 0x0700, 0x0700, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char '
    { 0x0000, 0x0000, 0x00F8, 0x03FE, 0x0707, 0x0401, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char (
    { 0x0000, 0x0000, 0x0401, 0x0707, 0x03FE, 0x00F8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char )
    { 0x0000, 0x0000, 0x0280, 0x0100, 0x07C0, 0x07C0, 0x0100, 0x0280, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char *
    { 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x01FC, 0x0020, 0x0020, 0x0020, 0x0000, 0x0000 }, // Code for char +
    { 0x0000, 0x0000, 0x000F, 0x000E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char ,
    { 0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char -
    { 0x0000, 0x0000, 0x000C, 0x000C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char .
    { 0x0000, 0x0000, 0x0000, 0x0003, 0x000C, 0x0070, 0x0180, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char /
    { 0x0000, 0x0000, 0x0000, 0x01F8, 0x03FC, 0x0204, 0x0204, 0x03FC, 0x01F8, 0x0000, 0x0000, 0x0000 }, // Code for char 0
    { 0x0000, 0x0000, 0x0000, 0x0000, 0x0104, 0x03FC, 0x03FC, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char 1
    { 0x0000, 0x0000, 0x0000, 0x010C, 0x031C, 0x0234, 0x0264, 0x03C4, 0x0184, 0x0000, 0x0000, 0x0000 }, // Code for char 2
    { 0x0000, 0x0000, 0x0000, 0x0108, 0x030C, 0x0244, 0x0244, 0x03FC, 0x01B8, 0x0000, 0x0000, 0x0000 }, // Code for char 3
    { 0x0000, 0x0000, 0x0000, 0x0030, 0x0050, 0x0090, 0x01FC, 0x03FC, 0x0010, 0x0000, 0x0000, 0x0000 }, // Code for char 4
    { 0x0000, 0x0000, 0x0000, 0x0008, 0x03CC, 0x03C4, 0x0244, 0x027C, 0x0238, 0x0000, 0x0000, 0x0000 }, // Code for char 5
    { 0x0000, 0x0000, 0x0000, 0x01F8, 0x03FC, 0x0244, 0x0244, 0x027C, 0x0038, 0x0000, 0x0000, 0x0000 }, // Code for char 6
    { 0x0000, 0x0000, 0x0000, 0x0200, 0x0200, 0x021C, 0x02FC, 0x03E0, 0x0300, 0x0000, 0x0000, 0x0000 }, // Code for char 7
    { 0x0000, 0x0000, 0x0000, 0x01B8, 0x03FC, 0x0244, 0x0244, 0x03FC, 0x01B8, 0x0000, 0x0000, 0x0000 }, // Code for char 8
    { 0x0000, 0x0000, 0x0000, 0x01C0, 0x03E4, 0x0224, 0x0224, 0x03FC, 0x01F8, 0x0000, 0x0000, 0x0000 }, // Code for char 9
    { 0x0000, 0x0000, 0x0000, 0x00CC, 0x00CC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char :
    { 0x0000, 0x0000, 0x0000, 0x00CF, 0x00CE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char ;
    { 0x0000, 0x0000, 0x0000, 0x0020, 0x0050, 0x0050, 0x0088, 0x0088, 0x0104, 0x0104, 0x0000, 0x0000 }, // Code for char <
    { 0x0000, 0x0000, 0x0000, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0000, 0x0000 }, // Code for char =
    { 0x0000, 0x0000, 0x0000, 0x0104, 0x0104, 0x0088, 0x0088, 0x0050, 0x0050, 0x0020, 0x0000, 0x0000 }, // Code for char >
    { 0x0000, 0x0000, 0x0000, 0x0100, 0x0234, 0x0274, 0x03C0, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char ?
    { 0x0000, 0x0000, 0x00F8, 0x0104, 0x0272, 0x02FA, 0x028A, 0x02F2, 0x02FA, 0x0108, 0x00F0, 0x0000 }, // Code for char @
    { 0x0000, 0x0000, 0x0000, 0x001C, 0x00FC, 0x03F0, 0x0310, 0x03F0, 0x00FC, 0x001C, 0x0000, 0x0000 }, // Code for char A
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x03FC, 0x0244, 0x0244, 0x03FC, 0x01B8, 0x0000, 0x0000, 0x0000 }, // Code for char B
    { 0x0000, 0x0000, 0x0000, 0x01F8, 0x03FC, 0x0204, 0x0204, 0x0204, 0x0204, 0x0000, 0x0000, 0x0000 }, // Code for char C
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x03FC, 0x0204, 0x0204, 0x030C, 0x01F8, 0x00F0, 0x0000, 0x0000 }, // Code for char D
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x03FC, 0x0244, 0x0244, 0x0244, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char E
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x03FC, 0x0240, 0x0240, 0x0240, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char F
    { 0x0000, 0x0000, 0x0000, 0x01F8, 0x03FC, 0x0204, 0x0204, 0x0224, 0x023C, 0x023C, 0x0000, 0x0000 }, // Code for char G
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x03FC, 0x0040, 0x0040, 0x0040, 0x03FC, 0x03FC, 0x0000, 0x0000 }, // Code for char H
    { 0x0000, 0x0000, 0x0000, 0x0204, 0x03FC, 0x03FC, 0x0204, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char I
    { 0x0000, 0x0000, 0x0000, 0x0004, 0x0204, 0x0204, 0x03FC, 0x03F8, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char J
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x03FC, 0x00F0, 0x0198, 0x030C, 0x0204, 0x0000, 0x0000, 0x0000 }, // Code for char K
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x03FC, 0x0004, 0x0004, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char L
    { 0x0000, 0x0000, 0x03FC, 0x0380, 0x01C0, 0x00E0, 0x0060, 0x00C0, 0x0180, 0x03FC, 0x03FC, 0x0000 }, // Code for char M
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x0380, 0x01C0, 0x00E0, 0x0070, 0x03FC, 0x0000, 0x0000, 0x0000 }, // Code for char N
    { 0x0000, 0x0000, 0x0000, 0x01F8, 0x03FC, 0x0204, 0x0204, 0x0204, 0x03FC, 0x01F8, 0x0000, 0x0000 }, // Code for char O
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x03FC, 0x0220, 0x0220, 0x03E0, 0x01C0, 0x0000, 0x0000, 0x0000 }, // Code for char P
    { 0x0000, 0x0000, 0x0000, 0x01F8, 0x03FC, 0x0204, 0x0206, 0x0207, 0x03FD, 0x01F9, 0x0000, 0x0000 }, // Code for char Q
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x03FC, 0x0220, 0x0230, 0x03F8, 0x01CC, 0x0004, 0x0000, 0x0000 }, // Code for char R
    { 0x0000, 0x0000, 0x0000, 0x01C4, 0x03E4, 0x0264, 0x0264, 0x027C, 0x0238, 0x0000, 0x0000, 0x0000 }, // Code for char S
    { 0x0000, 0x0000, 0x0000, 0x0200, 0x0200, 0x03FC, 0x03FC, 0x0200, 0x0200, 0x0000, 0x0000, 0x0000 }, // Code for char T
    { 0x0000, 0x0000, 0x0000, 0x03F8, 0x03FC, 0x0004, 0x0004, 0x0004, 0x03FC, 0x03F8, 0x0000, 0x0000 }, // Code for char U
    { 0x0000, 0x0000, 0x0000, 0x0380, 0x03F0, 0x007C, 0x007C, 0x03F0, 0x0380, 0x0000, 0x0000, 0x0000 }, // Code for char V
    { 0x0000, 0x0380, 0x03F0, 0x007C, 0x003C, 0x03E0, 0x03E0, 0x003C, 0x007C, 0x03F0, 0x0380, 0x0000 }, // Code for char W
    { 0x0000, 0x0000, 0x0000, 0x030C, 0x039C, 0x00F0, 0x00F0, 0x039C, 0x030C, 0x0000, 0x0000, 0x0000 }, // Code for char X
    { 0x0000, 0x0000, 0x0000, 0x0300, 0x03C0, 0x00FC, 0x00FC, 0x03C0, 0x0300, 0x0000, 0x0000, 0x0000 }, // Code for char Y
    { 0x0000, 0x0000, 0x0000, 0x021C, 0x023C, 0x0274, 0x02E4, 0x03C4, 0x0384, 0x0000, 0x0000, 0x0000 }, // Code for char Z
    { 0x0000, 0x0000, 0x0000, 0x07FF, 0x07FF, 0x0401, 0x0401, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char [
    { 0x0000, 0x0000, 0x0000, 0x0600, 0x0180, 0x0070, 0x000C, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char BackSlash
    { 0x0000, 0x0000, 0x0000, 0x0401, 0x0401, 0x07FF, 0x07FF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char ]
    { 0x0000, 0x0000, 0x0000, 0x0040, 0x0080, 0x0100, 0x0200, 0x0100, 0x0080, 0x0040, 0x0000, 0x0000 }, // Code for char ^
    { 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000 }, // Code for char _
    { 0x0000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0600, 0x0200, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char `
    { 0x0000, 0x0000, 0x0000, 0x0018, 0x00BC, 0x00A4, 0x00A4, 0x00FC, 0x007C, 0x0000, 0x0000, 0x0000 }, // Code for char a
    { 0x0000, 0x0000, 0x0000, 0x07FC, 0x07FC, 0x0084, 0x0084, 0x00FC, 0x0078, 0x0000, 0x0000, 0x0000 }, // Code for char b
    { 0x0000, 0x0000, 0x0000, 0x0078, 0x00FC, 0x0084, 0x0084, 0x0084, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char c
    { 0x0000, 0x0000, 0x0000, 0x0078, 0x00FC, 0x0084, 0x0084, 0x07FC, 0x07FC, 0x0000, 0x0000, 0x0000 }, // Code for char d
    { 0x0000, 0x0000, 0x0000, 0x0078, 0x00FC, 0x00A4, 0x00A4, 0x00E4, 0x0064, 0x0000, 0x0000, 0x0000 }, // Code for char e
    { 0x0000, 0x0000, 0x0000, 0x03FC, 0x07FC, 0x0480, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char f
    { 0x0000, 0x0000, 0x0000, 0x0078, 0x00FD, 0x0085, 0x0085, 0x00FF, 0x00FE, 0x0000, 0x0000, 0x0000 }, // Code for char g
    { 0x0000, 0x0000, 0x0000, 0x07FC, 0x07FC, 0x0080, 0x0080, 0x00FC, 0x007C, 0x0000, 0x0000, 0x0000 }, // Code for char h
    { 0x0000, 0x0000, 0x0000, 0x02FC, 0x02FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char i
    { 0x0000, 0x0000, 0x0000, 0x0081, 0x02FF, 0x02FE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char j
    { 0x0000, 0x0000, 0x0000, 0x07FC, 0x07FC, 0x0030, 0x0078, 0x00CC, 0x0084, 0x0000, 0x0000, 0x0000 }, // Code for char k
    { 0x0000, 0x0000, 0x0000, 0x07FC, 0x07FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char l
    { 0x0000, 0x00FC, 0x00FC, 0x0080, 0x0080, 0x00FC, 0x007C, 0x0080, 0x0080, 0x00FC, 0x007C, 0x0000 }, // Code for char m
    { 0x0000, 0x0000, 0x0000, 0x00FC, 0x00FC, 0x0080, 0x0080, 0x00FC, 0x007C, 0x0000, 0x0000, 0x0000 }, // Code for char n
    { 0x0000, 0x0000, 0x0000, 0x0078, 0x00FC, 0x0084, 0x0084, 0x00FC, 0x0078, 0x0000, 0x0000, 0x0000 }, // Code for char o
    { 0x0000, 0x0000, 0x0000, 0x00FF, 0x00FF, 0x0084, 0x0084, 0x00FC, 0x0078, 0x0000, 0x0000, 0x0000 }, // Code for char p
    { 0x0000, 0x0000, 0x0000, 0x0078, 0x00FC, 0x0084, 0x0084, 0x00FF, 0x00FF, 0x0000, 0x0000, 0x0000 }, // Code for char q
    { 0x0000, 0x0000, 0x0000, 0x00FC, 0x00FC, 0x0040, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char r
    { 0x0000, 0x0000, 0x0000, 0x0064, 0x00F4, 0x00B4, 0x00BC, 0x0098, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char s
    { 0x0000, 0x0000, 0x0000, 0x03F8, 0x03FC, 0x0084, 0x0084, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char t
    { 0x0000, 0x0000, 0x0000, 0x00F8, 0x00FC, 0x0004, 0x0004, 0x00FC, 0x00FC, 0x0000, 0x0000, 0x0000 }, // Code for char u
    { 0x0000, 0x0000, 0x0000, 0x00C0, 0x00F0, 0x003C, 0x003C, 0x00F0, 0x00C0, 0x0000, 0x0000, 0x0000 }, // Code for char v
    { 0x0000, 0x0000, 0x00F0, 0x00FC, 0x001C, 0x00F0, 0x00F0, 0x001C, 0x00FC, 0x00F0, 0x0000, 0x0000 }, // Code for char w
    { 0x0000, 0x0000, 0x0000, 0x00CC, 0x00FC, 0x0030, 0x0030, 0x00FC, 0x00CC, 0x0000, 0x0000, 0x0000 }, // Code for char x
    { 0x0000, 0x0000, 0x0000, 0x00C0, 0x00F3, 0x003F, 0x003C, 0x00F0, 0x00C0, 0x0000, 0x0000, 0x0000 }, // Code for char y
    { 0x0000, 0x0000, 0x0000, 0x008C, 0x009C, 0x00B4, 0x00E4, 0x00C4, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char z
    { 0x0000, 0x0000, 0x0000, 0x0020, 0x0020, 0x03FE, 0x07DF, 0x0401, 0x0401, 0x0000, 0x0000, 0x0000 }, // Code for char {
    { 0x0000, 0x0000, 0x0000, 0x0000, 0x07FF, 0x07FF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000 }, // Code for char |
    { 0x0000, 0x0000, 0x0000, 0x0401, 0x0401, 0x07DF, 0x03FE, 0x0020, 0x0020, 0x0000, 0x0000, 0x0000 }, // Code for char }
    { 0x0000, 0x0000, 0x0030, 0x0040, 0x0040, 0x0060, 0x0030, 0x0010, 0x0010, 0x0060, 0x0000, 0x0000 }, // Code for char ~
};